<?php

/**
 * @version		$Id: script.php 22354 2011-11-07 05:01:16Z github_bot $
 * @package		com_visforms
 * @copyright	Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

class com_visformsInstallerScript
{
    /*
     * Version that will be installed by this installer run
     * 
     * @var string
     */
    private $release;
    
    /*
     * Version that was installed before this installer run
     * 
     * @var string
     */
    private $oldRelease;
    
    /*
     * Minimum Joomla! release Version for this installation
     * 
     * @var string
     */
    private $minimum_joomla_release;
   
     /**
   * Object with instalation status information
   *
   * @var object
   */
   private $status;
    
    /**
	 * Constructor
	 *
	 * @param   JAdapterInstance  $adapter  The object responsable for running this script
	 */
   public function __construct(JAdapterInstance $adapter) 
    {
        $this->status = new stdClass();
        $this->status->fixTableVisforms = array();
        $this->status->modules = array();
        $this->status->plugins = array();
		$this->status->tables = array();
        $this->status->folders = array();
        $this->status->component = array();
		$this->release = $adapter->get( "manifest" )->version; 
		$this->minimum_joomla_release = $adapter->get( "manifest" )->attributes()->version;
        $this->oldRelease = "";
   }

	/**
	 * Called before any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
    public function preflight($route, JAdapterInstance $adapter) {
		$jversion = new JVersion();
        $msg = "";

		// abort if the current Joomla release is to old
		if( version_compare( $jversion->getShortVersion(), $this->minimum_joomla_release, 'lt' ) ) {
			Jerror::raiseWarning(null, JText::_('COM_VISFORMS_WRONG_JOOMLA_VERSION') .$this->minimum_joomla_release);
			return false;
		}

		// abort if the component being installed is not newer than the currently installed version
		if ( $route == 'update' ) {
			@chmod(JPath::clean(JPATH_ROOT . '/media/com_visforms/css/visforms.css'), 0777);
			$this->oldRelease = $this->getParam('version');
			$rel = $this->oldRelease . JText::_('COM_VISFORMS_TO') . $this->release;
			if ( version_compare( $this->release, $this->oldRelease, 'le' ) ) {
				Jerror::raiseWarning(null, JText::_('COM_VISFORMS_WRONG_VERSION') . $rel);
				return false;
			}
            else
            {
                //process postflight for specific versions
                if(version_compare($this->oldRelease, '2.0.0', 'lt'))
                {
                    $this->preFlightForVersion2_0_0();
                }
            }
		}
        else 
		{ 
			$rel = $this->release; 
		}
		//create installation success message (only display if complete installation is executed successfully)
		if ($route == 'update') 
        {
			$msg =  JText::_('COM_VISFORMS_UPDATE_VERSION') . $rel . JText::_('COM_VISFORMS_SUCESSFULL');
		}
		else if ($route == 'install') {
			$msg = JText::_('COM_VISFORMS_INSTALL_VERSION') . $rel . JText::_('COM_VISFORMS_SUCESSFULL');
		}

        $this->status->component = array('name' => 'visForms', 'type' => $route, 'msg' => $msg);
	}

	/**
	 * Called after any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
    public function postflight($route, JAdapterInstance $adapter) 
    {
        if($route == 'update')
        {
            //run specific component adaptation for specific update versions
            if(version_compare($this->oldRelease, '2.0.0', 'lt'))
            {
                $this->postFlightForVersion2_0_0();
            }  
			if(version_compare($this->oldRelease, '2.0.2', 'lt'))
            {
                $this->postFlightForVersion2_0_2();
            }
			if(version_compare($this->oldRelease, '2.1.0', 'lt'))
            {
                $this->postFlightForVersion2_1_0();
            }
        }
        
        if($route == 'install')
        {
            $this->createFolder(array('images', 'visforms'));
        }
        
        //Install or update all extensions that come with component visForms
        $this->installExtensions($route, $adapter);
	}

	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
    public function install(JAdapterInstance $adapter) 
	{
		//JFactory::getApplication()->enqueueMessage(JText::_('COM_VISFORMS_INSTALL_MESSAGE'));
	}

	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	//public function update(JAdapterInstance $adapter);

	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	public function uninstall(JAdapterInstance $adapter)
	{

		$db = JFactory::getDBO();
		$app = JFactory::getApplication();

		if ($db) 
		{
            //delete all visforms related tables in database
			$db->setQuery("SELECT * FROM #__visforms");
			$forms = $db->loadObjectList();
	
			$n=count($forms);
			for ($i=0; $i < $n; $i++)
			{
				$row = $forms[$i];
				$tn = "#__visforms_".$row->id;
				$db->setQuery("drop table if exists ".$tn);
				$db->query();
				if ($db->getErrorNum())
				{
					$this->status->tables[] = array('message' => JText::sprintf('DB function failed with error number %s <br /><span style="_QQ_"color: red;"_QQ_">%s</span>', $db->getErrorNum(), $db->getErrorMsg()));
					//echo JText::sprintf('DB function failed with error number %s <br /><span style="_QQ_"color: red;"_QQ_">%s</span>', $db->getErrorNum(), $db->getErrorMsg()).'<br />';
				}
				else
				{
					$this->status->tables[] = array('message' => JText::sprintf('COM_VISFORMS_DATA_TABLE_DROPPED', $row->id));
					//echo JText::sprintf('Data table of form %s dropped', $row->id) .'<br />'; 
				}
			}

			$db->setQuery("drop table if exists #__visfields");
			$db->query();			
			if ($db->getErrorNum())
			{
				$this->status->tables[] = array('message' => JText::sprintf('DB function failed with error number %s <br /><span style="_QQ_"color: red;"_QQ_">%s</span>', $db->getErrorNum(), $db->getErrorMsg()));
				//echo JText::sprintf('DB function failed with error number %s <br /><span style="_QQ_"color: red;"_QQ_">%s</span>', $db->getErrorNum(), $db->getErrorMsg()).'<br />';
			}
			else
			{
				$this->status->tables[] = array('message' => JText::_('COM_VISFORMS_FIELD_TABLE_DROPPED'));
				//echo JText::sprintf('Fields table dropped') .'<br />'; 
			}
			
			$db->setQuery("drop table if exists #__visforms");
			$db->query();			
			if ($db->getErrorNum())
			{
				$this->status->tables[] = array('message' => JText::sprintf('DB function failed with error number %s <br /><span style="_QQ_"color: red;"_QQ_">%s</span>', $db->getErrorNum(), $db->getErrorMsg()));
				//echo JText::sprintf('DB function failed with error number %s <br /><span style="_QQ_"color: red;"_QQ_">%s</span>', $db->getErrorNum(), $db->getErrorMsg()) .'<br />';
			}
			else
			{
				$this->status->tables[] = array('message' => JText::_('COM_VISFORMS_FORMS_TABLE_DROPPED'));
				//echo JText::sprintf('Forms table dropped') .'<br />'; 
			}
		}
		
        //uninstall plugins
        $manifest = $adapter->getParent()->manifest;
        $plugins = $manifest->xpath('plugins/plugin');
        foreach ($plugins as $plugin)
        {
            $name = (string)$plugin->attributes()->plugin;
            $group = (string)$plugin->attributes()->group;
            $plgWhere = $db->quoteName('type') . ' = ' . $db->quote('plugin') . ' AND ' . $db->quoteName('element') . ' = ' . $db->quote($name) . ' AND ' . $db->quoteName('folder') . ' = ' . $db->quote($group);
            $query = $db->getQuery(true);
            $query
                ->select($db->quoteName('extension_id'))
                ->from($db->quoteName('#__extensions'))
                ->where($plgWhere);
            //$query = "SELECT `extension_id` FROM #__extensions WHERE `type`='plugin' AND element = ".$db->Quote($name)." AND folder = ".$db->Quote($group);
            $db->setQuery($query);
            $extensions = $db->loadColumn();
            if (count($extensions))
            {
                foreach ($extensions as $id)
                {
                    $installer = new JInstaller;
                    $result = $installer->uninstall('plugin', $id);
                }
                $this->status->plugins[] = array('name' => $name, 'group' => $group, 'result' => $result);
            }
            
        }
        //uninstall modules
        $modules = $manifest->xpath('modules/module');
        foreach ($modules as $module)
        {
            $name = (string)$module->attributes()->module;
            $client = (string)$module->attributes()->client;
            if (is_null($client))
            {
                $client = 'site';
            }
            if($client == 'site')
            {
                $client_id = 0;
            }
            else
            {
                $client_id = 1;
            }
            $db = JFactory::getDBO();
            $modWhere = $db->quoteName('type') . ' = ' . $db->quote('module') . ' AND ' . $db->quoteName('element') . ' = ' . $db->quote($name) . ' AND ' . $db->quoteName('client_id') . ' = ' . $db->quote($client_id);
            $query = $db->getQuery(true);
            $query
                ->select($db->quoteName('extension_id'))
                ->from($db->quoteName('#__extensions'))
                ->where($modWhere);
            //$query = "SELECT `extension_id` FROM `#__extensions` WHERE `type`='module' AND element = ".$db->Quote($name). "AND Client_id = " . ($client == site) ? $db->Quote(0) : $db->Quote(1);
            $db->setQuery($query);
            $extensions = $db->loadColumn();
            if (count($extensions))
            {
                foreach ($extensions as $id)
                {
                    $installer = new JInstaller;
                    $result = $installer->uninstall('module', $id);
                }
                $this->status->modules[] = array('name' => $name, 'client' => $client, 'result' => $result);
            }
            
        }
        
        //delete folders in image folder
        jimport('joomla.filesystem.file');      
        $folder  = JPATH_ROOT.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'visforms';
        if(JFolder::exists($folder))
        {
            $result = array();
            $result[]     = JFolder::delete($folder);
            $this->status->folders[] = array('folder' => $folder, 'result' => $result[0]);  
        }
        
        //delete visuploads folder
        $folder  = JPATH_ROOT.DIRECTORY_SEPARATOR.'visuploads';
        if(JFolder::exists($folder))
        {
            $result = array();
            $result[]     = JFolder::delete($folder);
            $this->status->folders[] = array('folder' => $folder, 'result' => $result[0]);  
        }
        
        $this->uninstallationResults();
	}
    
    /*
     * Method to show installation results in a nicely formatted html table
     * HTML is captured by content buffer in adapter install function
     * 
     * @return void
     */
	
	 private function installationResults()
    {
        $language = JFactory::getLanguage();
        $language->load('com_visforms');
        $rows = 0; ?>
		<?php echo JText::_('COM_VISFORMS_INSTALL_MESSAGE'); ?>
        <img src="<?php echo JURI::base(); ?>/components/com_visforms/images/logo-banner.png" alt="visForms" align="right" />
        <h2><?php echo JText::_('COM_VISFORMS_INSTALLATION_STATUS'); ?></h2>
        <table class="adminlist table table-striped">
            <thead>
                <tr>
                    <th class="title" colspan="2" style="text-align: left;"><?php echo JText::_('COM_VISFORMS_EXTENSION'); ?></th>
                    <th width="30%" style="text-align: left;"><?php echo JText::_('COM_VISFORMS_STATUS'); ?></th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td colspan="3"></td>
                </tr>
            </tfoot>
            <tbody>
                <tr class="row0">
                    <td class="key" colspan="2"><?php echo JText::_('COM_VISFORMS_COMPONENT'); ?></td>
                    <td><strong><?php echo $this->status->component['msg']; ?></strong></td>
                </tr>
                <?php if (count($this->status->modules)): ?>
                <tr>
                    <th><?php echo JText::_('COM_VISFORMS_MODULE'); ?></th>
                    <th><?php echo JText::_('COM_VISFORMS_CLIENT'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->modules as $module): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key"><?php echo $module['name']; ?></td>
                    <td class="key"><?php echo ucfirst($module['client']); ?></td>
                    <td><?php echo ($module['result']) ? (($module['type'] == 'install') ? '<strong>' . JText::_('COM_VISFORMS_INSTALLED') : '<strong>' . JText::_('COM_VISFORMS_UPDATED')) : (($module['type'] == 'install') ? '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_INSTALLED') : '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_UPDATED')); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
                <?php if (count($this->status->plugins)): ?>
                <tr>
                    <th><?php echo JText::_('COM_VISFORMS_PLUGIN'); ?></th>
                    <th><?php echo JText::_('COM_VISFORMS_GROUP'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->plugins as $plugin): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key"><?php echo ucfirst($plugin['name']); ?></td>
                    <td class="key"><?php echo ucfirst($plugin['group']); ?></td>
                    <td><?php echo ($plugin['result']) ? (($plugin['type'] == 'install') ? '<strong>' . JText::_('COM_VISFORMS_INSTALLED') : '<strong>' . JText::_('COM_VISFORMS_UPDATED')) : (($plugin['type'] == 'install') ? '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_INSTALLED') : '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_UPDATED')); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
                 <?php if (count($this->status->folders)): ?>
                <tr>
                    <th colspan="2"><?php echo JText::_('COM_VISFORMS_FILESYSTEM'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->folders as $folder): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key" colspan="2"><?php echo ucfirst($folder['folder']); ?></td>
                    <td><?php echo ($folder['result']) ? '<strong>' . JText::_('COM_VISFORMS_CREATED') :  '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_CREATED'); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
                <?php if (count($this->status->fixTableVisforms)): ?>
                <tr>
                    <th colspan="2"><?php echo JText::_('COM_VISFORMS_UPDATE_FIX_FOR_FORM_DATA'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->fixTableVisforms as $recordset): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key" colspan="2"><?php echo JText::_('COM_VISFORMS_FORM_WITH_ID') . $recordset['form']; ?></td>
                    <td><?php echo ($recordset['result']) ? '<strong>' . $recordset['resulttext'] :  '<strong style="color: red">' . $recordset['resulttext']; ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    <?php
    }
	
	private function uninstallationResults()
    {
    $language = JFactory::getLanguage();
    $language->load('com_visforms');
    $rows = 0;
 ?>
        <h2><?php echo JText::_('COM_VISFORMS_REMOVAL_STATUS'); ?></h2>
        <table class="adminlist table table-striped">
            <thead>
                <tr>
                    <th class="title" colspan="2" style="text-align: left;"><?php echo JText::_('COM_VISFORMS_EXTENSION'); ?></th>
                    <th width="30%" style="text-align: left;"><?php echo JText::_('COM_VISFORMS_STATUS'); ?></th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td colspan="3"></td>
                </tr>
            </tfoot>
            <tbody>
                <tr class="row0">
                    <td class="key" colspan="2"><?php echo JText::_('COM_VISFORMS_COMPONENT'); ?></td>
                    <td><strong><?php echo JText::_('COM_VISFORMS_REMOVED'); ?></strong></td>
                </tr>
                <?php if (count($this->status->modules)): ?>
                <tr>
                    <th><?php echo JText::_('COM_VISFORMS_MODULE'); ?></th>
                    <th><?php echo JText::_('COM_VISFORMS_CLIENT'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->modules as $module): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key"><?php echo $module['name']; ?></td>
                    <td class="key"><?php echo ucfirst($module['client']); ?></td>
                    <td><?php echo ($module['result']) ? '<strong>' . JText::_('COM_VISFORMS_REMOVED') : '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_REMOVED'); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
        
                <?php if (count($this->status->plugins)): ?>
                <tr>
                    <th><?php echo JText::_('COM_VISFORMS_PLUGIN'); ?></th>
                    <th><?php echo JText::_('COM_VISFORMS_GROUP'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->plugins as $plugin): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key"><?php echo ucfirst($plugin['name']); ?></td>
                    <td class="key"><?php echo ucfirst($plugin['group']); ?></td>
                    <td><?php echo ($plugin['result']) ? '<strong>'. JText::_('COM_VISFORMS_REMOVED') : '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_REMOVED'); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
				<?php if (count($this->status->tables)){ ?>
				<tr>
                    <th><?php echo JText::_('COM_VISFORMS_TABLES'); ?></th>
                    <th></th>
                    <th></th>
                </tr>
					<?php foreach ($this->status->tables as $table){ ?>
					<tr class="row<?php echo(++$rows % 2); ?>">
						<td class="key" colspan="3"><?php echo ucfirst($table['message']); ?></td>
					</tr>
					<?php } ?>
				<?php } ?>
                <?php if (count($this->status->folders)): ?>
                <tr>
                    <th colspan="2"><?php echo JText::_('COM_VISFORMS_FILESYSTEM'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($this->status->folders as $folder): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key" colspan="2"><?php echo ucfirst($folder['folder']); ?></td>
                    <td><?php echo ($folder['result']) ? '<strong>' . JText::_('COM_VISFORMS_DELETED') :  '<strong style="color: red">' . JText::_('COM_VISFORMS_NOT_DELETED'); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    <?php
    }
    
    private function postFlightForVersion2_0_0 ()
    {  
        //create visforms folder in image directory and copy an index.html into it
       $this->createFolder(array('images', 'visforms'));
       
       //fix recordsets in visforms table
       $this->fixTableVisforms2_0_0(); 
       
       //fix recordsets in visfields table
       $this->fixTableVisfields2_0_0();
       
       //delete old files no longer used
       $this->deleteOldFiles2_0_0();
        
    }
	
	private function postFlightForVersion2_0_2()
	{
		//Bugfixes for 2.0.0 and 2.0.1
		
		//field emailfromname in table visforms was missing after installation but not after update
		$db = JFactory::getDbo();         
		$query= "ALTER TABLE " . $db->quoteName('#__visforms') . " ADD COLUMN " . $db->quoteName('emailfromname') . " text AFTER " . $db->quoteName('emailfrom');
		$db->setQuery($query);
		$db->execute();
	
		//theme folder was not deleted properly
        jimport( 'joomla.filesystem.file' );

		$oldfile =JPath::clean(JPATH_ROOT . '/media/com_visforms/js/theme');
		if ( JFolder::exists($oldfile) ) 
		{
			JFolder::delete($oldfile);
		}
       
	}
    
    private function createFolder($folders = array())
    {
        //create visforms folder in image directory and copy an index.html into it
        jimport('joomla.filesystem.file');
        $folder  = JPATH_ROOT;//.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'visforms';
        foreach ($folders as $name) 
        {
            $folder .= DIRECTORY_SEPARATOR . $name;
        }
        
        if (($folder != JPATH_ROOT) && !(JFolder::exists($folder)))
        {
            $result = array();
            $result[]     = JFolder::create($folder);
            $this->status->folders[] = array('folder' => $folder, 'result' => $result[0]);
            $src  = JPATH_ROOT.DS.'media'.DIRECTORY_SEPARATOR.'com_visforms'.DIRECTORY_SEPARATOR.'index.html';
            $dest = JPath::clean($folder.DIRECTORY_SEPARATOR.'index.html');

            $result[] = JFile::copy($src, $dest);
            $this->status->folders[] = array('folder' => $folder.DIRECTORY_SEPARATOR.'index.html', 'result' => $result[1]);
        }
    }
    
    private function preFlightForVersion2_0_0()
    {
        //Repair table #__schema which was not used before    
        //Just create a dataset with extension id and old version (before update).
        $db = JFactory::getDbo();
        
        $query = $db->getQuery(true);
        $query->select($db->quoteName('extension_id'))
            ->from('#__extensions')
            ->where($this->getComponentWhereStatement());
        $db->setQuery($query);


        if ($eid = $db->loadResult())
        {
            $query->clear();
            $query->insert($db->quoteName('#__schemas'));
            $query->columns(array($db->quoteName('extension_id'), $db->quoteName('version_id')));
            $query->values($eid . ', ' . $db->quote($this->oldRelease));
            $db->setQuery($query);
            $db->execute();
        }
        //Backup old visforms table in database
    }
    
    public function installExtensions($route, JAdapterInstance $adapter) {
		$db = JFactory::getDBO();
        $src = $adapter->getParent()->getPath('source');
        $manifest = $adapter->getParent()->manifest;
        $plugins = $manifest->xpath('plugins/plugin');
        foreach ($plugins as $plugin)
        {
            $name = (string)$plugin->attributes()->plugin;
            $group = (string)$plugin->attributes()->group;
            $newVersion = (string) $plugin->attributes()->version;
            $version = "";
            $plgWhere = $db->quoteName('type') . ' = ' . $db->quote('plugin') . ' AND ' . $db->quoteName('element') . ' = ' . $db->quote($name) . ' AND ' . $db->quoteName('folder') . ' = ' . $db->quote($group);
            $query = $db->getQuery(true);
            $query
                ->select($db->quoteName('extension_id'))
                ->from($db->quoteName('#__extensions'))
                ->where($plgWhere);
            $db->setQuery($query);
            $extension = $db->loadColumn();
            $path = $src.'/plugins/'.$group;
            if (JFolder::exists($src.'/plugins/'.$group.'/'.$name))
            {
                $path = $src.'/plugins/'.$group.'/'.$name;
            }
            $installer = new JInstaller;
            //Plugin does already exist
			if (count($extension))
			{
                //make sure we have got only on id, if not use the first
                if (is_array($extension))
                {
                    $extension = $extension[0];
                }
                //check if we need to update
				$version = $this->getParam('version', (int) $extension);
                if ( version_compare( $newVersion, $version, 'gt' ))
                {
                    $result = $installer->update($path);
                    $this->status->plugins[] = array('name' => $name, 'group' => $group, 'result' => $result, 'type' => 'update');
                }
			}
			else
			{
                //we install the plugin
				$result = $installer->install($path);
                //and enable it
                $query = 'UPDATE ' . $db->quoteName('#__extensions') . ' SET ' . $db->quoteName('enabled') . ' = 1 WHERE ' . $plgWhere;
                $db->setQuery($query);
                $db->query();
                $this->status->plugins[] = array('name' => $name, 'group' => $group, 'result' => $result, 'type' => 'install');
            }
        }		
        $modules = $manifest->xpath('modules/module');
        foreach ($modules as $module)
        {
            $name = (string)$module->attributes()->module;
            $client = (string)$module->attributes()->client;
            $newVersion = (string) $module->attributes()->version;
            $version = "";
            if (is_null($client))
            {
                $client = 'site';
            }
            if($client == 'site')
            {
                $client_id = 0;
            }
            else
            {
                $client_id = 1;
            }
            $modWhere = $db->quoteName('type') . ' = ' . $db->quote('module') . ' AND ' . $db->quoteName('element') . ' = ' . $db->quote($name) . ' AND ' . $db->quoteName('client_id') . ' = ' . $db->quote($client_id);
            $query = $db->getQuery(true);
            $query
                ->select($db->quoteName('extension_id'))
                ->from($db->quoteName('#__extensions'))
                ->where($modWhere);
            $db->setQuery($query);
            $extension = $db->loadColumn();
            ($client == 'administrator') ? $path = $src.'/administrator/modules/'.$name : $path = $src.'/modules/'.$name;
			
            $installer = new JInstaller;
            if (count($extension))
			{
                //make sure we have got only on id, if not use the first
                if (is_array($extension))
                {
                    $extension = $extension[0];
                }
                //check if we need to update
				$version = $this->getParam('version', (int) $extension);
                if ( version_compare( $newVersion, $version, 'gt' ))
                {
                    $result = $installer->update($path);
                    $this->status->modules[] = array('name' => $name, 'client' => $client, 'result' => $result, 'type' => 'update');
                }
			}
			else
			{
				$result = $installer->install($path);
                $this->status->modules[] = array('name' => $name, 'client' => $client, 'result' => $result, 'type' => 'install');
            }

        }
		$this->installationResults();
	}
    
    /*
	 * get a variable from the manifest cache of the version that is to be updated.
     * 
     * @param string name Parametername
     * @param int id    extension id
     * 
     * @return string parameter value
	 */
	private function getParam( $name, $eid = 0) {
		$db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName('manifest_cache'));
        $query->from($db->quoteName('#__extensions'));
        //check if a extenstion id is given. If yes we want a parameter from this extension
        if($eid != 0)
        {
            $query->where($db->quoteName('extension_id') . ' = ' . $db->quote($eid)); 
        }
        else
        {
            $query->where($this->getComponentWhereStatement());
        }
            
		$db->setQuery($query);
		$manifest = json_decode( $db->loadResult(), true );
		return $manifest[ $name ];
	}
    
    /*
	 * sets parameter values in the component's row of the extension table
	 */
	private function setParams($param_array) {
		if ( count($param_array) > 0 ) {
			// read the existing component value(s)
			$db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query
                ->select($db->quoteName('params'))
                ->from($db->quoteName('#__extensions'))
                ->where($this->getComponentWhereStatement());
			$db->setQuery($query);
			$params = json_decode( $db->loadResult(), true );
			// add the new variable(s) to the existing one(s)
			foreach ( $param_array as $name => $value ) {
				$params[ (string) $name ] = (string) $value;
			}
			// store the combined new and existing values back as a JSON string
			$paramsString = json_encode( $params );
			$db->setQuery('UPDATE #__extensions SET params = ' .
				$db->quote( $paramsString ) . ' WHERE ' . $this->getComponentWhereStatement());
				$db->query();
		}
	}
    
    /*
     * Methode to create where statement to manipulate component dataset in extensions table
     * 
     * @return  string  where statement to select the visForms component dataset in extensions table
     */
    
    private function getComponentWhereStatement()
    {
        $db = JFactory::getDbo();
        $where = $db->quoteName('type') . ' = ' . $db->quote('component') . ' AND ' . $db->quoteName('element') . ' = ' . $db->quote('com_visforms') . ' AND ' . $db->quoteName('name') . ' = ' . $db->quote('visforms');
        return $where;
    }
    
    /*Method to fix recordsets in table visForms according to changes in tablestructure during update from visforms 1.x to 2.0.0
     * 
     */
    private function fixTableVisforms2_0_0() 
    {   
       //fix form data
       //include classes and paths to Visforms models and tables
       jimport('joomla.database.table');
       jimport('joomla.application.component.model');
       JTable::addIncludePath(JPATH_SITE.'/administrator/components/com_visforms/tables', 'VisformsTable');
       JModel::addIncludePath(JPATH_SITE.'/administrator/components/com_visforms/models', 'VisformsModel');
       
       //get all form records from database
       $db = JFactory::getDbo();
       $query = $db->getQuery(true);
       $query
           ->select($db->quoteName(array('id', 'asset_id', 'name', 'created_by', 'checked_out', 'checked_out_time', 'saveresult', 'uploadpath', 'access', 'language', 'allowedextensions')))
           ->from($db->quoteName('#__visforms'));
       $db->setQuery($query);
       $forms = $db->loadAssocList();
       if (count($forms) > 0)
       {
           $model = JModel::getInstance('Visform', 'VisformsModel', array());
           		
           foreach($forms as $form)
           {
               //delete recordset in asset table (parent_id and name has changed so the recordset will not longer be found)
               if (isset($form['asset_id']) && $form['asset_id'] != 0)
               {
                   //delete recordset from asset table
                   $query->clear();
                   $query
                       ->delete($db->quoteName('#__assets'))
                       ->where($db->quoteName('asset_id') . ' = ' . $form['asset_id']);
                   $db->setQuery($query);
                   if($result = $db->query())
                   {
                       //set asset_id in form to 0 so that it can be set anew when recordset is stored in database
                       $form['asset_id'] = 0;
                   }
                   
               }
               
               //use only save characters in name. Done by function check() in table class: It is important, that field name is selected with SQL Statement!
               
               //set a created_by if value is 0
               if(isset($form['created_by']))
               {
                   $user = JFactory::getUser();
                   if($form['created_by'] == 0)
                   {
                       //no user set in created_by we fill the field with the user id of user who runs the update
                        $form['created_by'] = $user->id;
                   }
                   else
                   {
                       //we check if the userid is valid in this Joomla! installation
                       $query->clear();
                       $query->select($db->quoteName('id'))
                           ->from('#__users');
                       $db->setQuery($query);
                       $users = $db->loadAssocList('id');
                       if(!(in_array($form['created_by'], $users)))
                       {
                           $form['created_by'] = $user->id;
                       } 
                   }
               }
               
               //create datatable if saveresult is true and it doesn't exists
               if(isset($form['saveresult']) && $form['saveresult'] == 1)
               {
                   if(!$result = $model->createDataTable($form['id']))
                   {
                       $this->status->fixTableVisforms[] = array('form' => $form['id'], 'result' => false, 'resulttext' => JText::_('COM_VISFORMS_CREATION_OF_DATATABLE_FAILED'));
                   }
                   else 
                   {
                       $this->status->fixTableVisforms[] = array('form' => $form['id'], 'result' => true, 'resulttext' => JText::_('COM_VISFORMS_CREATION_OF_DATATABLE_SUCCESSFUL'));
                   }
               }
               
               
               //fix uploadpath
               if (isset($form['uploadpath']) && $form['uploadpath'] != "") 
               {
                   //check if uploadpath is a valid path and the directory is writable
                   jimport('joomla.filesystem.file');
                   $folder = JPath::clean($form['uploadpath']);
                   //check if the last character is the directory separator. If so remove it
                   $folder = ( $folder{strlen($folder)-1} == DIRECTORY_SEPARATOR ) ? substr( $folder, 0, strlen($folder)-1) : $folder;
                   //check if JPATH_ROOT has changed
                   //escape backslashes for pregmatch
                   $root = explode('\\', JPATH_ROOT);
                   $root = implode('\\\\', $root);
                   $pattern = '#' . $root . '#';
                   $match = preg_match($pattern, $folder);
                   
                   if(!(JFolder::exists($folder)) || !(is_writable($folder)) || ($match == 0))
                   {
                       //create a folder to put the uploades files into
                       $this->createFolder(array('visuploads'));
                       $folder = 'visuploads';
                       $fixUploadPathresult = "";
                       if(isset($form['saveresult']) && $form['saveresult'] == true)
                       { 
                           $fixUploadPathresult = JText::sprintf('COM_VISFORMS_FIX_UPLOADDIRECTORY', JPath::clean($form['uploadpath']));
                       }
                       else
                       {
                            $fixUploadPathresult = JText::_('COM_VISFORMS_INVALID_UPLOAD_PATH_CHANGED_TO_DEFAULT');
                       }
                       $this->status->fixTableVisforms[] = array('form' => $form['id'], 'result' => false, 'resulttext' => $fixUploadPathresult);
                   }
                   else
                   {
                       //make folder a folder (remove root string and trim from slashes/backslashes) always use slash as a seperator
                       $folder = preg_replace($pattern, '', $folder);
                       $folder = preg_replace('#\\\\#', '/', $folder);
                       $folder = trim($folder, '/');
                   }
                   $form['uploadpath'] = $folder;
               }
               
               //set access to 1 if it is not set to a valid value already
                if(isset($form['access']) && ($form['access'] != 1 && $form['access'] != 2 && $form['access'] != 3 && $form['access'] != 4))
               {
                   $form['access'] = 1;
               }
               
               //set a language tag if non exists
               if(isset($form['language']) && $form['language'] == '')
               {
                   $form['language'] = '*';
               }
               
               //checkin all checkedout recordsets
                if(isset($form['checked_out']) && $form['checked_out'] != 0)
               {
                   $form['checked_out'] = 0;
               }
               if(isset($form['checked_out_time']) && $form['checked_out_time'] != '0000-00-00 00:00:00')
               {
                   $form['checked_out_time'] = '0000-00-00 00:00:00';
               }
               
               //set defaultvalues for new fields
               $form['exportsettings'] = array('exppublishfieldsonly' => 1, 'exppublisheddataonly' => 1, 'expfieldpublished' => 0, 'expfieldip' => 0, 'expfieldid' => 0, 'usewindowscharset' => 1); 
               
               if ($form['allowedextensions'] == "")
               {
                   $form['allowedextensions'] = "bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS";
               }
               //By saving the recordset via model we make sure, that there is created correct dataset in asset table as well
               $model->save($form);
           }
       }
    }
    
    /*Methode to fix recordsets in visfields table according to changes in tablestructure during update from visforms 1.x to 2.0.0
     * 
     */
    private function fixTableVisfields2_0_0()
    {
        //fix fields
        //include classes and paths to Visforms models and tables
       jimport('joomla.database.table');
       jimport('joomla.application.component.model');
       jimport('joomla.form.form');
       JTable::addIncludePath(JPATH_SITE.'/administrator/components/com_visforms/tables', 'VisformsTable');
       JModel::addIncludePath(JPATH_SITE.'/administrator/components/com_visforms/models', 'VisformsModel');
       JForm::addFormPath(JPATH_SITE.'/administrator/components/com_visforms/models/forms');
       
       //get all form records from database
       $db = JFactory::getDbo();
       $query = $db->getQuery(true);
       $query
           ->select($db->quoteName(array('id', 'fid', 'name', 'asset_id', 'created_by', 'checked_out', 'checked_out_time', 'typefield', 'defaultvalue', 'mandatory', 'custominfo', 'customerror', 'readonly', 'fillwith')))
           ->from($db->quoteName('#__visfields'));
       $db->setQuery($query);
       $fields = $db->loadAssocList();
       if (count($fields) > 0)
       {
            $model = JModel::getInstance('Visfield', 'VisformsModel', array());
            foreach($fields as $field)
            {
                //get form data
                $query->clear();
                $query->select($db->quoteName(array('id', 'created_by', 'saveresult', 'uploadpath')))
                    ->from($db->quoteName('#__visforms'))
                    ->where($db->quoteName('id') . " = " . $field['fid']);
                $db->setQuery($query);
                $db->query();
                $num_rows = $db->getNumRows();
                $form = $db->loadAssoc();
                //delete field recordsets which are not attached to a form
                if ($num_rows == 0)
                {
                    $query->clear();
                    $query
                        ->delete($db->quoteName('#__visfields'))
                        ->where($db->quoteName('id') . " = " . $field['id']);
                    $db->setQuery($query);
                    $db->query();
                }
                else
                {
                    //use only save characters in name is handled by save

                    //set a created_by if value is 0
                    if(isset($field['created_by']))
                    {
                        $user = JFactory::getUser();
                        if($field['created_by'] == 0)
                        {
                            //no user set in created_by we fill the field with the user id of user who created the form
                            if(isset($form['created_by']) && $form['created_by'] != 0)
                            {
                                $field['created_by'] = $form['created_by'];
                            }
                            else
                            {
                                //handled by save
                            }
                        }
                        else
                        {
                            //we check if the userid is valid in this Joomla! installation
                            $query->clear();
                            $query->select($db->quoteName('id'))
                                ->from('#__users');
                            $db->setQuery($query);
                            $users = $db->loadAssocList('id');
                            if(!(in_array($field['created_by'], $users)))
                            {
                                if(isset($form['created_by']) && $form['created_by'] != 0)
                                {
                                    $field['created_by'] = $form['created_by'];
                                }
                                else
                                {
                                    //the user id of the user who runs the update
                                     $field['created_by'] = $user->id;
                                }
                            } 
                        }
                    }

                    //checkin all checkedout recordsets
                    if(isset($field['checked_out']) && $field['checked_out'] != 0)
                    {
                        $field['checked_out'] = 0;
                    }
                    if(isset($field['checked_out_time']) && $field['checked_out_time'] != '0000-00-00 00:00:00')
                    {
                        $field['checked_out_time'] = '0000-00-00 00:00:00';
                    }

                    //extraxt old default values
                    $this->fixFieldValues2_0_0($field);

                    $model->save($field);
                    
                    //Storage format of data for fields of type file (upload) has changed
                    //old format:JPATH_ROOT/path/to/uploaddirectory/filename.extension
                    //new format: {"folder": "path/to/uploaddirectory", "file" : "filename.extension"}
                    if(isset($field['typefield']) && $field['typefield'] == "file")
                    {
                        //check if form has value "saveresult" set to true
                        if(isset($form['saveresult']) && $form['saveresult'] == true)
                        {
                            $uploadfield = 'F' . $field['id'];
                            //get data recordset from table visforms_fid
                            $query->clear();
                            $query->select($db->quoteName(array('id', $uploadfield)))
                                ->from($db->quoteName('#__visforms_' . $form['id']));
                            $db->setQuery($query);
                            $datas = $db->loadAssocList();
                            if (count($datas) > 0)
                            {
                                foreach($datas as $data)
                                {
                                    if(isset($data[$uploadfield]) && $data[$uploadfield] != "")
                                    {
                                        //include some helpful classes
                                        jimport('joomla.filesystem.file');
                                        //make original value a clean path
                                        $uploadfileWithPath = JPATH::clean($data[$uploadfield]);
                                        //get filename
                                        $uploadfile = basename($uploadfileWithPath);
                                        if(isset($form['uploadpath']) && $form['uploadpath'] == "")
                                        {
                                            $folder = $form['uploadpath'];
                                        }
                                        else
                                        {
                                            $folder = 'visuploads';
                                        }
                                        $data[$uploadfield] = array("folder" => $folder, "file" => $uploadfile);
                                        $registry = new JRegistry;
                                        $registry->loadArray($data[$uploadfield]);
                                        $data[$uploadfield] = (string)$registry;
                                        $query->clear();
                                        $query->update($db->quoteName('#__visforms_' . $form['id']))
                                            ->set($db->quoteName($uploadfield) . " = " . $db->quote($data[$uploadfield]))
                                            ->where($db->quoteName('id') . " = " . $data['id']);
                                        $db->setQuery($query);
                                        $db->query();                                        
                                    }
                                     
                                }
                            }
                        }

                    }
                }
            }
       }
       
       //drop fields no longer used from table visfields
       $columnsToDelete = array('mandatory', 'custominfo', 'customerror', 'readonly', 'customvalidation', 'fillwith');
       foreach ($columnsToDelete as $columnToDelete)
       {
           $queryStr = ("ALTER TABLE " . $db->quoteName('#__visfields') . "DROP COLUMN " . $db->quoteName($columnToDelete));
           $db->setQuery($queryStr);
           $db->query();
       }
       
    }
    
    /*
     * Method to extract defaultvalues which are stored in a proprietary format
     * 
     * @param array $field array of field data
     * 
     * @return array $field array of field data
     */
    private function fixFieldValues2_0_0(&$field)
    {
        $oldValues = new stdClass();
        if(isset($field['defaultvalue']) && $field['defaultvalue'] != "" && isset($field['typefield']) && $field['typefield'] != "")
        {
            $opt = explode("[--]", $field['defaultvalue']);

			$oldValues->t_wrap = '';
			$oldValues->t_typeBT = '';	
			$oldValues->t_texttype = '';	
			$oldValues->t_displayRB = '';
			$oldValues->t_filluid = '';
			$oldValues->t_noborderFS = '';
			$oldValues->d_format  = '';
			$oldValues->d_daydate  = '';
			$oldValues->d_initvalueD = '';
			$oldValues->t_listHS  = '';
			$oldValues->t_listHRB  = '';
			
			switch ($field['typefield'])
			{
				case 'text':					
					$key1 = explode("===", $opt[0]);
					$key2 = explode("===", $opt[1]);
					$key3 = explode("===", $opt[2]);
					$key4 = explode("===", $opt[3]);
					$oldValues->t_initvalueT = $key1[1];
					$oldValues->t_maxchar = $key2[1];
					$oldValues->t_texttype = $key3[1];
					$oldValues->t_minchar = $key4[1];
					if (count($opt) > 4)
					{
						$key5 = explode("===", $opt[4]);
						$oldValues->d_format = $key5[1];
					}
					if (count($opt) > 5)
					{
						$key6 = explode("===", $opt[5]);
						$oldValues->d_daydate = $key6[1];
					}
					if (count($opt) > 6)
					{
						$key7 = explode("===", $opt[6]);
						$oldValues->d_initvalueD = $key7[1];
					}
					break;
	
				case 'hidden':
					$key1 = explode("===", $opt[0]);
					$oldValues->t_initvalueH = $key1[1];
					if (count($opt) > 1)
					{
						$key2 = explode("===", $opt[1]);
						$oldValues->t_filluid = $key2[1];
					}
					break;
					
				case 'textarea':
					$key1 = explode("===", $opt[0]);
					$key2 = explode("===", $opt[1]);
					$key3 = explode("===", $opt[2]);
					$key4 = explode("===", $opt[3]);
					$key5 = explode("===", $opt[4]);
					$key6 = explode("===", $opt[5]);
					$key7 = explode("===", $opt[6]);
					$oldValues->t_initvalueTA = $key1[1];
					$oldValues->t_HTMLEditor = $key2[1];
					$oldValues->t_columns = $key3[1];
					$oldValues->t_rows = $key4[1];
					$oldValues->t_wrap = $key5[1];
					$oldValues->t_maxchar = $key6[1];		
					$oldValues->t_minchar = $key7[1];				
					break;
	
				case 'checkbox':
					$key1 = explode("===", $opt[0]);
					$oldValues->t_initvalueCB = $key1[1];
					$key2 = explode("===", $opt[1]);
					$oldValues->t_checkedCB = $key2[1];
					break;
					
				case 'radiobutton':
					$key1 = explode("===", $opt[0]);
					$oldValues->t_listHRB = $key1[1];
					if (count($opt) > 1)
					{
						$key2 = explode("===", $opt[1]);
						$oldValues->t_displayRB = $key2[1];
					}
					break;

				case 'select':
					$key1 = explode("===", $opt[0]);
					$key2 = explode("===", $opt[1]);
					$key3 = explode("===", $opt[2]);
					$oldValues->t_multipleS = $key1[1];
					$oldValues->t_heightS = $key2[1];
					$oldValues->t_listHS = $key3[1];					
					break;

				case 'button':
					$key1 = explode("===", $opt[0]);
					$oldValues->t_typeBT = $key1[1];
					break;
	
				case 'fieldsep':
					$key1 = explode("===", $opt[0]);
					$oldValues->t_noborderFS = $key1[1];
					break;
			}
            $field['defaultvalue'] = array();
        }
        //reset typefield for radio
        if (isset($field['typefield']) && $field['typefield'] == "radiobutton")
        {
            $field['typefield'] = "radio";
        }
        
        //reset typefield for file
        if (isset($field['typefield']) && $field['typefield'] == "fileupload")
        {
            $field['typefield'] = "file";
        }
        
        // reset typefield for text fields
        if (isset($oldValues->t_texttype) && $oldValues->t_texttype != "")
        {
            $field['typefield'] = $oldValues->t_texttype;
        }
        //reset typefield for buttons
        if (isset($oldValues->t_typeBT) && $oldValues->t_typeBT != "")
        {
            $field['typefield'] = $oldValues->t_typeBT;
        }
        
        //fix old field mandatory into defaultvalues _attribute_required
        //not for hidden fields, buttons and fieldseparators
        if (isset($field['typefield']) && ($field['typefield'] != "hidden" && $field['typefield'] != "image" && $field['typefield'] != "submit" && $field['typefield'] != "reset" && $field['typefield'] != "fieldsep"))
        {
            if(isset($field['mandatory']))
            {                
                if($field['mandatory'] == 1)
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_required'] = "required";
                }
                else
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_required'] = "";
                }
            }
        }
        
        //fix old field readonly into defaultvalues _attribute_readonly
        //only for "text" fields and textareas
        if (isset($field['typefield']) && ($field['typefield'] == "text" || $field['typefield'] == "email" || $field['typefield'] == "date" || $field['typefield'] == "url" || $field['typefield'] == "number" || $field['typefield'] == "password" || $field['typefield'] == "textarea"))
        {
            if(isset($field['readonly']))
            {
                if($field['readonly'] == 1)
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_readonly'] = "readonly";
                }
                else
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_readonly'] = "";
                }
            }
        }
        
        //fix old field custominfo and customerror into defaultvalues _custominfo
        //not for hidden fields, buttons and fieldseparators
        if (isset($field['typefield']) && ($field['typefield'] != "hidden" && $field['typefield'] != "image" && $field['typefield'] != "submit" && $field['typefield'] != "reset" && $field['typefield'] != "fieldsep"))
        {
            if(isset($field['custominfo']))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_custominfo'] = $field['custominfo'];
            }
            if(isset($field['customerror']))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_customerror'] = $field['customerror'];
            }
        }
        
        //reset defaultvalue for text, email, urls, password fields
        if (isset($field['typefield']) && ($field['typefield'] == "text" || $field['typefield'] == "email" || $field['typefield'] == "url" || $field['typefield'] == "password"))
        {
            if(isset($oldValues->t_minchar))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_validate_minlength'] = $oldValues->t_minchar;
            }
            if(isset($oldValues->t_maxchar))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_maxlength'] = $oldValues->t_maxchar;
            }
            if(isset($oldValues->t_initvalueT))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_value'] = $oldValues->t_initvalueT;
            }
        }
        
        //reset supplemantary defautlvalues for email  fields
        if (isset($field['typefield']) &&  $field['typefield'] == "email")
        {
            if(isset($field['fillwith']))
            {
                if($field['fillwith'] == "usremail")
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_fillwith'] = "usermail";
                }
                else
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_fillwith'] = $field['fillwith'];
                }
            }
        }
        
        //reset supplemantary defautlvalues for text fields
        if (isset($field['typefield']) && $field['typefield'] == "text" )
        {
            if(isset($field['fillwith']))
            {
                if($field['fillwith'] == "usrname")
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_fillwith'] = "1";
                }
                else if($field['fillwith'] == "usrusername")
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_fillwith'] = "2";
                }
                else
                {
                    $field['defaultvalue']['f_'. $field['typefield'] . '_fillwith'] = "0";
                }
            }
        }
        
        //reste defaultvalues for date fields
        if (isset($field['typefield']) && $field['typefield'] == "date")
        {
            if(isset($oldValues->d_format))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_format'] = $oldValues->d_format;
            }
            if(isset($oldValues->d_initvalueD))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_value'] = $oldValues->d_initvalueD;
            }
            if(isset($oldValues->d_daydate))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_daydate'] = $oldValues->d_daydate;
            }
        }
        
        //reset defaultvalue for numbers
        if (isset($field['typefield']) && $field['typefield'] == "number")
        {
            if(isset($oldValues->t_minchar))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_min'] = $oldValues->t_minchar;
            }
            if(isset($oldValues->t_maxchar))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_max'] = $oldValues->t_maxchar;
            }
            if(isset($oldValues->t_initvalueT))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_value'] = $oldValues->t_initvalueT;
            }
        }
        
        //reset defaultvalue for hidden fields
        if (isset($field['typefield']) && $field['typefield'] == "hidden")
        {
            if(isset($oldValues->t_filluid))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_filluid'] = $oldValues->t_filluid;
            }
           
            if(isset($oldValues->t_initvalueH))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_value'] = $oldValues->t_initvalueH;
            }
        }
        
        //reset defaultvalue for textarea
        if (isset($field['typefield']) && $field['typefield'] == "textarea")
        {
            if(isset($oldValues->t_minchar))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_validate_minlength'] = $oldValues->t_minchar;
            }
            if(isset($oldValues->t_maxchar))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_maxlength'] = $oldValues->t_maxchar;
            }
            if(isset($oldValues->t_initvalueTA))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_initvalue'] = $oldValues->t_initvalueTA;
            }
            if(isset($oldValues->t_HTMLEditor))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_HTMLEditor'] = $oldValues->t_HTMLEditor;
            }
            if(isset($oldValues->t_columns))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_cols'] = $oldValues->t_columns;
            }
            if(isset($oldValues->t_rows))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_rows'] = $oldValues->t_rows;
            }
            if(isset($oldValues->t_wrap))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_wrap'] = $oldValues->t_wrap;
            }
        }
        
        //reset defaultvalue for checkbox
        if (isset($field['typefield']) && $field['typefield'] == "checkbox")
        {
            if(isset($oldValues->t_initvalueCB))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_value'] = $oldValues->t_initvalueCB;
            }
            if(isset($oldValues->t_checkedCB))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_checked'] = $oldValues->t_checkedCB;
            }
        }
        
        //reset defaultvalue for radios
        if (isset($field['typefield']) && $field['typefield'] == "radio")
        {
            if(isset($oldValues->t_displayRB))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_display'] = $oldValues->t_displayRB;
            }
            if(isset($oldValues->t_listHRB))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_list_hidden'] = $oldValues->t_listHRB;
            }
        }
        
        //reset defaultvalue for select
        if (isset($field['typefield']) && $field['typefield'] == "select")
        {
            if(isset($oldValues->t_multiple))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_multiple'] = $oldValues->t_multiple;
            }
            if(isset($oldValues->t_heightS))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_size'] = $oldValues->t_heightS;
            }
            if(isset($oldValues->t_listHS))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_list_hidden'] = $oldValues->t_listHS;
            }
        }
        
        //reset defaultvalue for fieldsep
        if (isset($field['typefield']) && $field['typefield'] == "fieldsep")
        {
            if(isset($oldValues->t_noborderFS))
            {
                $field['defaultvalue']['f_'. $field['typefield'] . '_noborder'] = $oldValues->t_noborderFS;
            }
        }
        
        //set new defaultvalues
        //attribute_class
        if (isset($field['typefield']) && ($field['typefield'] == "text" || $field['typefield'] == "email" || $field['typefield'] == "url" || $field['typefield'] == "number" || $field['typefield'] == "password" || $field['typefield'] == "textarea" || $field['typefield'] == "file"))
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_class'] = " inputbox visCSSinput ";
        }
        if (isset($field['typefield']) && $field['typefield'] == "date" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_class'] = " inputbox visCSStop10 ";
        }
        if (isset($field['typefield']) && $field['typefield'] == "checkbox" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_class'] = " visCSStop10 ";
        }
        if (isset($field['typefield']) && $field['typefield'] == "radio" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_class'] = " inputbox visCSSbot5 ";
        }
        if (isset($field['typefield']) && $field['typefield'] == "select" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_class'] = " visCSSinput ";
        }
        if (isset($field['typefield']) && $field['typefield'] == "fieldsep")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_class'] = " visCSStop10 ";
        }
        
        //htmlTag
        if (isset($field['typefield']) && ($field['typefield'] == "text" || $field['typefield'] == "email" || $field['typefield'] == "date" || $field['typefield'] == "url" || $field['typefield'] == "number" || $field['typefield'] == "password" || $field['typefield'] == "hidden" || $field['typefield'] == "checkbox" || $field['typefield'] == "radio" || $field['typefield'] == "file" || $field['typefield'] == "image" || $field['typefield'] == "reset" || $field['typefield'] == "submit"))
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_htmlTag'] = "input";
        }
        if (isset($field['typefield']) && $field['typefield'] == "textarea" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_htmlTag'] = "textarea";
        }
        if (isset($field['typefield']) && $field['typefield'] == "select" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_htmlTag'] = "select";
        }
        if (isset($field['typefield']) && $field['typefield'] == "fieldsep" )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_htmlTag'] = "hr";
        }
        
        //attribute_type
        if (isset($field['typefield']) && ($field['typefield'] == "text" || $field['typefield'] == "hidden") )
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "text";
        }
        if (isset($field['typefield']) && $field['typefield'] == "email")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "email";
        }
        if (isset($field['typefield']) && $field['typefield'] == "date")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "date";
        }
        if (isset($field['typefield']) && $field['typefield'] == "url")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "url";
        }
        if (isset($field['typefield']) && $field['typefield'] == "number")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "number";
        }
        if (isset($field['typefield']) && $field['typefield'] == "password")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "password";
        }
        if (isset($field['typefield']) && $field['typefield'] == "checkbox")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "checkbox";
        }
        if (isset($field['typefield']) && $field['typefield'] == "radio")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "radio";
        }
        if (isset($field['typefield']) && $field['typefield'] == "file")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "file";
        }
        if (isset($field['typefield']) && $field['typefield'] == "image")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "image";
        }
        if (isset($field['typefield']) && $field['typefield'] == "reset")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "reset";
        }
        if (isset($field['typefield']) && $field['typefield'] == "submit")
        {
            $field['defaultvalue']['f_'. $field['typefield'] . '_attribute_type'] = "submit";
        }
    }
    
    private function deleteOldFiles2_0_0()
    {
       $filesToDelete = array(
           '/administrator/components/com_visforms/css/mootabs.css',
           '/administrator/components/com_visforms/js/mootabs.js',
           '/administrator/components/com_visforms/views/visdata/tmpl/default.php',
           '/administrator/components/com_visforms/views/visdata/tmpl/detail.php',
           '/administrator/components/com_visforms/views//visfield/tmpl/visfield_tpl.php',
           '/administrator/components/com_visforms/views/visform/tmpl/form.php',
           '/media/com_visforms/js/formcheck.js',
           '/media/com_visforms/js/theme'
           );
       jimport( 'joomla.filesystem.file' );
       foreach ($filesToDelete as $fileToDelete)
       {
           $oldfile =JPath::clean(JPATH_ROOT . $fileToDelete);
            if ( JFile::exists($oldfile) ) 
            {
                JFile::delete($oldfile);
            }
       }
    }
	
	private function postFlightForVersion2_1_0()
    {
        //fix recordsets in visforms table
        $this->fixTableVisforms2_1_0();
		//add new menu params
		$menu_params = array('sortorder' => 'id', 'display_num' => '20');
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select($db->quoteName(array('id', 'link','params')))
			->from($db->quoteName('#__menu'))
			->where($db->quoteName('type') . ' = ' . $db->quote('component'));
		$db->setQuery($query);
		if ($menus = $db->loadObjectList())
		{
			foreach ($menus as $menu)
			{
				if ((isset($menu->link)) && ($menu->link != "") && (strpos($menu->link, "view=visformsdata") !== false))
				{
					$params = json_decode( $menu->params, true );
					// add the new variable(s) to the existing one(s)
					foreach ( $menu_params as $name => $value ) 
					{
						$params[ (string) $name ] = (string) $value;
						// store the combined new and existing values back as a JSON string
						$paramsString = json_encode( $params );
						$db->setQuery('UPDATE #__menu SET params = ' .
						$db->quote( $paramsString ) . ' WHERE ' . $db->quoteName('id') . ' = ' . $db->quote($menu->id));
						$db->query();
					}
				}
			}
		}
    }
    
    private function fixTableVisforms2_1_0()
    {
       $db = JFactory::getDbo();
       $query = $db->getQuery(true);
	   //Former emailreceipt params into new param field emeilreceiptsettings
       $query
           ->select($db->quoteName(array('id', 'emailreceiptincfield', 'emailreceiptincfile', 'emailrecipientincfilepath')))
           ->from($db->quoteName('#__visforms'));
       $db->setQuery($query);
       $forms = $db->loadObjectList();
       if (count($forms) > 0)
       {
           foreach ($forms as $form)
           {
               $emailreceiptsettings = array();
               if (isset($form->emailreceiptincfield))
               {
                   $emailreceiptsettings['emailreceiptincfield'] = $form->emailreceiptincfield;
               }
               else
               {
                   $emailreceiptsettings['emailreceiptincfield'] = 0;
               }
               if (isset($form->emailreceiptincfile))
               {
                   $emailreceiptsettings['emailreceiptincfile'] = $form->emailreceiptincfile;
               }
               else
               {
                   $emailreceiptsettings['emailreceiptincfile'] = 0;
               }
               if (isset($form->emailrecipientincfilepath))
               {
                   $emailreceiptsettings['emailrecipientincfilepath'] = $form->emailrecipientincfilepath;
               }
               else
               {
                   $emailreceiptsettings['emailrecipientincfilepath'] = 0;
               }
			   $emailreceiptsettings['emailreceiptinccreated'] = 1;
			   $emailreceiptsettings['emailreceiptincformtitle'] = 1;
               if (is_array($emailreceiptsettings))
               {
                   $registry = new JRegistry;
                   $registry->loadArray($emailreceiptsettings);
                   $emailreceiptsettings = (string)$registry;
                   $query = $db->getQuery(true);
                   $query->update($db->quoteName('#__visforms'))
                       ->set($db->quoteName('emailreceiptsettings') . " = " . $db->quote($emailreceiptsettings))
                       ->where($db->quoteName('id') . " = " . $db->quote($form->id));
                   $db->setQuery($query);
                   $result = $db->query();
                   if (!$result)
                   {
                       //add a message that update went wrong
                   }

               }
           }
		   //drop fields no longer used from table visforms
            $columnsToDelete = array('emailreceiptincfield', 'emailreceiptincfile', 'emailrecipientincfilepath');
            foreach ($columnsToDelete as $columnToDelete)
            {
                $queryStr = ("ALTER TABLE " . $db->quoteName('#__visforms') . "DROP COLUMN " . $db->quoteName($columnToDelete));
                $db->setQuery($queryStr);
                $db->query();
            }
		}
		   //Former emailreceipt params into new param field emeilreceiptsettings
		   $query = $db->getQuery(true);
       $query
           ->select($db->quoteName(array('id', 'displayip', 'displaydetail', 'autopublish')))
           ->from($db->quoteName('#__visforms'));
       $db->setQuery($query);
       $forms = $db->loadObjectList();
       if (count($forms) > 0)
       {
           foreach ($forms as $form)
           {
               $frontendsettings = array();
               if (isset($form->displayip))
               {
                   $frontendsettings['displayip'] = $form->displayip;
               }
               else
               {
                   $frontendsettings['displayip'] = 0;
               }
               if (isset($form->displaydetail))
               {
                   $frontendsettings['displaydetail'] = $form->displaydetail;
               }
               else
               {
                   $frontendsettings['displaydetail'] = 0;
               }
                if (isset($form->autopublish))
               {
                   $frontendsettings['autopublish'] = $form->autopublish;
               }
               else
               {
                   $frontendsettings['autopublish'] = 1;
               }
			   $frontendsettings['displayid'] = 0;
               if (is_array($frontendsettings))
               {
                   $registry = new JRegistry;
                   $registry->loadArray($frontendsettings);
                   $frontendsettings = (string)$registry;
                   $query = $db->getQuery(true);
                   $query->update($db->quoteName('#__visforms'))
                       ->set($db->quoteName('frontendsettings') . " = " . $db->quote($frontendsettings))
                       ->where($db->quoteName('id') . " = " . $db->quote($form->id));
                   $db->setQuery($query);
                   $result = $db->query();
                   if (!$result)
                   {
                       //add a message that update went wrong
                   }

               }
           }
           //drop fields no longer used from table visforms
            $columnsToDelete = array('displayip', 'displaydetail', 'autopublish');
            foreach ($columnsToDelete as $columnToDelete)
            {
                $queryStr = ("ALTER TABLE " . $db->quoteName('#__visforms') . "DROP COLUMN " . $db->quoteName($columnToDelete));
                $db->setQuery($queryStr);
                $db->query();
            }
       }
    }
}

?>
