<?php
/**
 * Visfields view for Visforms
 *
 * @author       Aicha Vack
 * @see           visforms is extended and rivised adaptation of ckforms from cookex (http://www.cookex.eu) for Joomla 2.5
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );

/**
 * visfields View
 *
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 *
 * @since        Joomla 1.6 
 */
class VisformsViewVisfields extends JView
{
	protected $form;
	protected $items;
	protected $state;
	protected $canDo;
	
	/**
	 * visfields view display method
	 * @return void
	 * @since Joomla 1.6
	 **/
	function display($tpl = null)
	{
		$fid = JRequest::getVar('fid', 0);
		// Get data from the model
		$this->form	= $this->get('Form');
		$this->items = $this->get('Items');
		$this->state = $this->get('State');
		$pagination = $this->get('Pagination');
		$this->canDo = VisformsHelper::getActions($fid);
		
		$document = JFactory::getDocument();
		$css = '.icon-48-visform {background:url(../administrator/components/com_visforms/images/logo-banner.png) no-repeat;}';
   		$document->addStyleDeclaration($css);
		JToolBarHelper::title(JText::_( 'COM_VISFORMS_VISFORM_FIELDS' ), 'visform' );
		if ($this->canDo->get('core.edit.state'))  {
			JToolBarHelper::publishList('visfields.publish');
			JToolBarHelper::unpublishList('visfields.unpublish');
			JToolBarHelper::checkin('visfields.checkin');
		}
		
		if ($this->canDo->get('core.delete')) {
			JToolBarHelper::deleteList('COM_VISFORMS_DELETE_FORM_TRUE', 'visfields.delete', 'COM_VISFORMS_DELETE');
		}
		
		if ($this->canDo->get('core.edit'))  {
			JToolBarHelper::editListX('visfield.edit');
		}
		if ($this->canDo->get('core.create')) {
			JToolBarHelper::addNewX('visfield.add');
		}
		JToolBarHelper::divider();
		JToolBarHelper::back('Forms','index.php?option=com_visforms');



		$this->assignRef('pagination', $pagination);

		parent::display($tpl);
	}
}
