<?php
/**
 * Visforms default view for Visforms
 *
 * @author       Aicha Vack
 * @see           visforms is extended and rivised adaptation of ckforms from cookex (http://www.cookex.eu) for Joomla 2.5
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

//no direct access
 defined('_JEXEC') or die('Restricted access'); 

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

$user		= JFactory::getUser();
$userId		= $user->get('id');
?>

<form action="<?php echo JRoute::_('index.php?option=com_visforms');?>" method="post" name="adminForm">
<fieldset id="filter-bar">
		<div class="filter-search fltlft">
			<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_CONTENT_FILTER_SEARCH_DESC'); ?>" />

			<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
		</div>
<div class="filter-select fltrt">
	
	<select name="filter_access" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php echo JText::_('JOPTION_SELECT_ACCESS');?></option>
				<?php echo JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text', $this->state->get('filter.access'));?>
			</select>
	<select name="filter_published" class="inputbox" onchange="this.form.submit()">
		<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
		<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions', array('trash'=>false, 'archived'=>false)), 'value', 'text', $this->state->get('filter.published'), true);?>
	</select>

	<select name="filter_language" class="inputbox" onchange="this.form.submit()">
		<option value=""><?php echo JText::_('JOPTION_SELECT_LANGUAGE');?></option>
		<?php echo JHtml::_('select.options', JHtml::_('contentlanguage.existing', true, true), 'value', 'text', $this->state->get('filter.language'));?>
	</select>
	
</div>	</fieldset>
	<div class="clr"> </div>

	<table class="adminlist">
	<thead>
		<tr>
			<th width="3%">
				<input type="checkbox" name="toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
			</th>			
			<th width="40%">
				<?php echo JHtml::_('grid.sort', 'COM_VISFORMS_TITLE', 'a.title', $listDirn, $listOrder); ?>
			</th>
            <th width="5%">
                <?php echo JHtml::_('grid.sort', 'COM_VISFORMS_PUBLISHED', 'a.published', $listDirn, $listOrder); ?>	
            </th>
			<th width="10%">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ACCESS', 'access_level', $listDirn, $listOrder); ?>
			</th>
			<th width="5%">
				<?php echo JHtml::_('grid.sort', 'COM_VISFORMS_FIELDS', 'nbfields', $listDirn, $listOrder); ?>
			</th>
			<th width="5%">
				<?php echo JHtml::_('grid.sort', 'COM_VISFORMS_AUTHOR', 'username', $listDirn, $listOrder); ?>
			</th>
			<th width="10%">
				<?php echo JHtml::_('grid.sort', 'COM_VISFORMS_DATE', 'a.created', $listDirn, $listOrder); ?>
			</th>
			<th width="15%">
				<?php echo JText::_( 'COM_VISFORMS_DATA' ); ?>
			</th>
			<th width="5%">
				<?php echo JHtml::_('grid.sort', 'COM_VISFORMS_HITS', 'a.hits', $listDirn, $listOrder); ?>
			</th>
			<th width="5%">
					<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
				</th>
			<th width="3%" nowrap="nowrap">
				<?php echo JHtml::_('grid.sort', 'COM_VISFORMS_ID', 'a.id', $listDirn, $listOrder); ?>
			</th>
		</tr>			
	</thead>
	<?php
	$k = 0;
	$n=count( $this->items );
	for ($i=0; $i < $n; $i++)
	{
		$row = &$this->items[$i];
		$checked 	= JHTML::_('grid.id',   $i, $row->id );
		$link 		= JRoute::_( 'index.php?option=com_visforms&task=visform.edit&id='. $row->id );
		$fields		= JRoute::_( 'index.php?option=com_visforms&view=visfields&fid='. $row->id );
		$savedData 	= JRoute::_( 'index.php?option=com_visforms&view=visdatas&fid='. $row->id );
		$canCreate	= $user->authorise('core.create',		'com_visforms.visform.'.$row->id);
		$canEdit	= $user->authorise('core.edit',			'com_visforms.visform.'.$row->id);
		$canCheckin	= $user->authorise('core.manage',		'com_visforms') || $row->checked_out == $userId || $row->checked_out == 0;
		$canEditOwn	= $user->authorise('core.edit.own',		'com_visforms.visform.'.$row->id) && $row->created_by == $userId;
		$canChange	= $user->authorise('core.edit.state',	'com_visforms.visform.'.$row->id) && $canCheckin;
		$published =  JHtml::_('jgrid.published', $row->published, $i, 'visforms.', $canChange, 'cb');
		
		?>
			<td class="center">
				<?php echo $checked; ?>
			</td>
			<td>
				<?php if ($row->checked_out) : ?>
						<?php echo JHtml::_('jgrid.checkedout', $i, $user->name, $row->checked_out_time, 'visforms.', $canCheckin); ?>
				<?php endif; ?>
				<?php if ($canEdit || $canEditOwn) : ?>
				<a href="<?php echo $link; ?>"><?php echo $this->escape($row->title); ?></a>
				<p class="smallsub">
					<?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($row->name));?>
				</p>
				<?php else : ?>
				<?php echo $this->escape($row->title); ?>
				<p class="smallsub">
					<?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($row->name));?>
				</p>
				<?php endif; ?>
			</td>
            <td class="center">
                <?php echo $published;?>
            </td>
			<td class="center">
					<?php echo $this->escape($row->access_level); ?>
				</td>
            <td class="center">
				<?php if ($canEdit || $canEditOwn) : ?>
					<a href="<?php echo $fields; ?>"><?php echo $row->nbfields; ?></a>
				<?php else : ?>
					<?php echo $row->nbfields; ?>
				<?php endif; ?>

            </td>
			<td class="center">
				<?php echo $this->escape($row->username); ?>
			</td>
			<td class="center">
				<?php //echo $row->created; 
				?>
				<?php echo JHtml::_('date', $row->created, JText::_('DATE_FORMAT_LC4')); ?>
			</td>
			<td class="center">
            <?php 
				if ($canEdit || $canEditOwn) :
					if ($row->saveresult == '1')
					{
				?>
					<a href="<?php echo $savedData; ?>"><?php echo JText::_( 'COM_VISFORMS_DISPLAY_DATA' ); ?></a>
				<?php 
					} else {
				?>
					&nbsp;
				<?php 
					}
				?>
				<?php else : ?>
					&nbsp;
				<?php endif; ?>
			</td>			
           	<td class="center">
				<?php echo $row->hits; ?>
			</td>
			<td class="center">
					<?php if ($row->language=='*'):?>
						<?php echo JText::alt('JALL', 'language'); ?>
					<?php else:?>
						<?php echo $row->language_title ? $this->escape($row->language_title) : JText::_('JUNDEFINED'); ?>
					<?php endif;?>
				</td>
           	<td>
				<?php echo $row->id; ?>
			</td>
		</tr>
		<?php
		$k = 1 - $k;
	}
	?>
    
    
    <tfoot>
    <tr>
      <td colspan="11"><?php echo $this->pagination->getListFooter(); ?></td>
    </tr>
  	</tfoot>
    
	</table>
	<?php //Load the batch processing form. ?>
	<?php
	if ($this->canDo->get('core.create')) {
		echo $this->loadTemplate('batch'); 
	}	
	?>
<div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHtml::_('form.token'); ?>
</div>
</form>

 <?php JHTML::_('visforms.creditsBackend'); ?>